####################################################################################################

#   Copyright (C) 2021 Dominique PUNSOLA

#   This file is part of Cognatus.
# 
#   Cognatus is free software: you can redistribute it and modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
# 
#   Cognatus is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
# 
#   You should have received a copy of the GNU General Public License
#   along with Cognatus.  If not, see <https://www.gnu.org/licenses/>.

####################################################################################################

#   Copyright (C) 2021 Dominique PUNSOLA

#   Ce fichier est une partie de Cognatus.
#   
#   Cognatus est un logiciel libre ; vous pouvez le redistribuer et le modifier 
#   au titre des clauses de la Licence Publique Gnrale GNU, telle que publie par 
#   la Free Software Foundation ; soit la version 3 de la Licence, ou 
#   ( votre discrtion) une version ultrieure quelconque. 
#   
#   Cognatus est distribu dans l'espoir qu'il sera utile, 
#   mais SANS AUCUNE GARANTIE ; sans mme une garantie implicite de 
#   COMMERCIABILITE ou DE CONFORMITE A UNE UTILISATION PARTICULIERE. Voir la 
#   Licence Publique Gnrale GNU pour plus de dtails. 
#   
#   Vous devriez avoir reu un exemplaire de la Licence Publique Gnrale GNU 
#   avec Cognatus ; si ce n'est pas le cas, voyez <https://www.gnu.org/licenses/>.

####################################################################################################
# mode debug

Set-StrictMode -Version 3

Add-Type -Name Window -Namespace Console -MemberDefinition '
[DllImport("Kernel32.dll")]
public static extern IntPtr GetConsoleWindow();
[DllImport("user32.dll")]
public static extern bool ShowWindow(IntPtr hWnd, Int32 nCmdShow);
'

####################################################################################################
# Assembly

Add-Type -AssemblyName System.Windows.Forms 
Add-Type -AssemblyName System.Drawing
[System.Windows.Forms.Application]::EnableVisualStyles()

$assemblyFile = (Resolve-Path ("System.Data.SQLite.dll")).path
[Reflection.Assembly]::LoadFile($assemblyFile) | Out-Null

####################################################################################################
# cration d'une base en mmoire
$global:conn_mem = New-Object -TypeName System.Data.SQLite.SQLiteConnection
$global:conn_mem.ConnectionString = "Data Source=" + ":memory:"
$global:conn_mem.Open()


####################################################################################################
# langue
$langue = (Get-WinSystemLocale).name.split('-')[0]
#  $langue = "nl"

####################################################################################################
# tables de mois

if ($langue -eq "es") {
$table_mois=@{}
$table_mois.add(1,"Enero")
$table_mois.add(2,"Febrero")
$table_mois.add(3,"Marzo")
$table_mois.add(4,"Abril")
$table_mois.add(5,"Mayo")
$table_mois.add(6,"Junio")
$table_mois.add(7,"Julio")
$table_mois.add(8,"Agosto")
$table_mois.add(9,"Septiembre")
$table_mois.add(10,"Octubre")
$table_mois.add(11,"Noviembre")
$table_mois.add(12,"Diciembre")
} elseif ($langue -eq "it") {
$table_mois=@{}
$table_mois.add(1,"Gennaio")
$table_mois.add(2,"Febbraio")
$table_mois.add(3,"Marzo")
$table_mois.add(4,"Aprile")
$table_mois.add(5,"Maggio")
$table_mois.add(6,"Giugno")
$table_mois.add(7,"Luglio")
$table_mois.add(8,"Agosto")
$table_mois.add(9,"Settembre")
$table_mois.add(10,"Ottobre")
$table_mois.add(11,"Novembre")
$table_mois.add(12,"Dicembre")
} elseif ($langue -eq "de") {
$table_mois=@{}
$table_mois.add(1,"Januar")
$table_mois.add(2,"Februar")
$table_mois.add(3,"Mrz")
$table_mois.add(4,"April")
$table_mois.add(5,"Mai")
$table_mois.add(6,"Juni")
$table_mois.add(7,"Juli")
$table_mois.add(8,"August")
$table_mois.add(9,"September")
$table_mois.add(10,"Oktober")
$table_mois.add(11,"November")
$table_mois.add(12,"Dezember")
} elseif ($langue -eq "nl") {
$table_mois=@{}
$table_mois.add(1,"Januari")
$table_mois.add(2,"Februari")
$table_mois.add(3,"Maart")
$table_mois.add(4,"April")
$table_mois.add(5,"Mei")
$table_mois.add(6,"Juni")
$table_mois.add(7,"Juli")
$table_mois.add(8,"Augustus")
$table_mois.add(9,"September")
$table_mois.add(10,"Oktober")
$table_mois.add(11,"November")
$table_mois.add(12,"Dezember")
} else {
$table_mois=@{}
$table_mois.add(1,"Janvier")
$table_mois.add(2,"Fvrier")
$table_mois.add(3,"Mars")
$table_mois.add(4,"Avril")
$table_mois.add(5,"Mai")
$table_mois.add(6,"Juin")
$table_mois.add(7,"Juillet")
$table_mois.add(8,"Aot")
$table_mois.add(9,"Septembre")
$table_mois.add(10,"Octobre")
$table_mois.add(11,"Novembre")
$table_mois.add(12,"Dcembre")
}

####################################################################################################
# tables de libells

if ($langue -eq "es") {
$table_lib=@{}
$table_lib.add(1,"Fecha de pascua (versin 1.1)")
$table_lib.add(2,"Gregoriano")
$table_lib.add(12,">= 1583")
$table_lib.add(3,"Julian (>= 325)")
$table_lib.add(4,"Clculo")
$table_lib.add(5,"Julian - Gregoriano")
$table_lib.add(6,"Fuente")
$table_lib.add(7,"El calendario solo est disponible a partir del ao 1753 (inicio del calendario gregoriano en los pases anglosajones)")
$table_lib.add(8,"Mostrar menos")
$table_lib.add(9,"Mostrar ms")
$table_lib.add(10,"Ao anterior")
$table_lib.add(11,"Prximo ao")
$table_lib.add(21,"Esta es la fecha de Pascua calculada en el calendario juliano
- en un momento y lugar donde se usa el calendario juliano
- o en un momento y lugar donde se usa el calendario gregoriano, pero donde la iglesia usa el calendario juliano
En ambos casos, si queremos la fecha correspondiente en el calendario gregoriano, habr que convertir la fecha juliana
`nEsta no es la fecha de Pascua calculada en el calendario gregoriano y luego convertida a una fecha en el calendario juliano.")
$table_lib.add(22,"Esta es la fecha de Pascua anterior, calculada en el calendario juliano y convertida al calendario gregoriano")
$table_lib.add(23,"El ao debe ser inferior a 8000")
} elseif ($langue -eq "it") {
$table_lib=@{}
$table_lib.add(1,"Data di Pasqua (versione 1.1)")
$table_lib.add(2,"Gregoriano")
$table_lib.add(12,">= 1583")
$table_lib.add(3,"Giuliano (>= 325)")
$table_lib.add(4,"Calcolo")
$table_lib.add(5,"Giuliano - Gregoriano")
$table_lib.add(6,"Fonte")
$table_lib.add(7,"Il calendario  disponibile solo dall'anno 1753 (inizio del calendario gregoriano nei paesi anglosassoni)")
$table_lib.add(8,"Mostra meno")
$table_lib.add(9,"Mostrar piu")
$table_lib.add(10,"Anno precedente")
$table_lib.add(11,"Anno seguente")
$table_lib.add(21,"Questa  la data di Pasqua calcolata nel calendario giuliano
- in un momento e in un luogo in cui  in uso il calendario giuliano
- o in un momento e luogo in cui  in uso il calendario gregoriano, ma dove la chiesa usa il calendario giuliano
In entrambi i casi, se vogliamo la data corrispondente nel calendario gregoriano, bisogner convertire la data giuliana
`nQuesta non  la data della Pasqua calcolata nel calendario gregoriano e poi convertita in una data del calendario giuliano.")
$table_lib.add(22,"Questa  la precedente data di Pasqua, calcolata nel calendario giuliano e convertita nel calendario gregoriano")
$table_lib.add(23,"L'anno deve essere minore di 8000")
} elseif ($langue -eq "de") {
$table_lib=@{}
$table_lib.add(1,"Osterdatum (version 1.1)")
$table_lib.add(2,"Gregorianisch")
$table_lib.add(12,">=1583")
$table_lib.add(3,"Julian (>= 325)")
$table_lib.add(4,"Berechnung")
$table_lib.add(5,"Julian - Gregorianisch")
$table_lib.add(6,"Quelle")
$table_lib.add(7,"Der Kalender ist erst ab dem Jahr 1753 verfgbar (Beginn des gregorianischen Kalenders in angelschsischen Lndern)")
$table_lib.add(8,"Weniger anzeigen")
$table_lib.add(9,"Mehr anzeigen")
$table_lib.add(10,"Vorheriges Jahr")
$table_lib.add(11,"Nchstes Jahr")
$table_lib.add(21,"Dies ist das im Julianischen Kalender berechnete Osterdatum
- zu einer Zeit und an einem Ort, an dem der Julianische Kalender verwendet wird
- oder zu einer Zeit und an einem Ort, an dem der gregorianische Kalender verwendet wird, die Kirche jedoch den julianischen Kalender verwendet
In beiden Fllen muss das julianische Datum konvertiert werden, wenn wir das entsprechende Datum im gregorianischen Kalender wnschen
`nDies ist nicht das im gregorianischen Kalender berechnete und dann in ein Datum im julianischen Kalender umgewandelte Osterdatum.")
$table_lib.add(22,"Dies ist das vorherige Osterdatum, berechnet im julianischen Kalender und konvertiert in den gregorianischen Kalender")
$table_lib.add(23,"Jahr muss kleiner als 8000 sein")
} elseif ($langue -eq "nl") {
$table_lib=@{}
$table_lib.add(1,"Paasdatum (versie 1.1)")
$table_lib.add(2,"Gregoriaans")
$table_lib.add(12,">=1583")
$table_lib.add(3,"Juliaans (>= 325)")
$table_lib.add(4,"Berekening")
$table_lib.add(5,"Juliaans - Gregoriaans")
$table_lib.add(6,"Bron")
$table_lib.add(7,"De kalender is pas beschikbaar vanaf het jaar 1753 (begin van de Gregoriaanse kalender in Angelsaksische landen)")
$table_lib.add(8,"Toon minder")
$table_lib.add(9,"Toon meer")
$table_lib.add(10,"Vorig jaar")
$table_lib.add(11,"Volgend jaar")
$table_lib.add(21,"Dit is de datum van Pasen berekend in de Juliaanse kalender
- op een tijd en plaats waar de Juliaanse kalender in gebruik is
- of op een tijd en plaats waar de Gregoriaanse kalender in gebruik is, maar waar de kerk de Juliaanse kalender gebruikt
In beide gevallen, als we de overeenkomstige datum in de Gregoriaanse kalender willen, zal de Juliaanse datum moeten worden omgezet
`nHet is niet de datum van Pasen berekend in de Gregoriaanse kalender en dan omgezet naar een datum in de Juliaanse kalender.")
$table_lib.add(22,"Dit is de vorige paasdatum, berekend in de Juliaanse kalender en omgezet naar de Gregoriaanse kalender")
$table_lib.add(23,"Jaar moet minder zijn dan 8000")
} else {
$table_lib=@{}
$table_lib.add(1,"Date de Pques (version 1.1)")
$table_lib.add(2,"Grgorien")
$table_lib.add(12,">= 1583")
$table_lib.add(3,"Julien (>= 325)")
$table_lib.add(4,"Calcul")
$table_lib.add(5,"Julien - Grgorien")
$table_lib.add(6,"Source")
$table_lib.add(7,"Le calendrier n'est disponible qu' partir de l'anne 1753 (dbut du calendrier grgorien dans les pays anglo-saxons)")
$table_lib.add(8,"Afficher moins")
$table_lib.add(9,"Afficher plus")
$table_lib.add(10,"Anne prcdente")
$table_lib.add(11,"Anne suivante")
$table_lib.add(21,"Il s'agit de la date de Pques calcule dans le calendrier julien
-  une poque et un lieu o le calendrier julien est en usage
- ou  une poque et un lieu o le calendrier grgorien est en usage, mais o l'glise utilise le calendrier julien
Dans les 2 cas, si l'on veut la date correspondante dans le calendrier grgorien, la date julienne devra tre convertie
`nIl ne s'agit pas de de la date de Pques calcule dans le calendrier grgorien puis convertie en date dans le calendrier julien.")
$table_lib.add(22,"Il s'agit de la date de Pques prcdente, calcule dans le calendrier julien, et convertie dans le calendrier grgorien")
$table_lib.add(23,"L'anne doit tre infrieure  8000")
}

####################################################################################################
# date de Paques
$PaquesForm = New-Object System.Windows.Forms.Form -Property @{width = "450" ; height = "380" ; ControlBox = $true ; ShowInTaskBar = $true ; FormBorderStyle = "Fixed3D"
text = $table_lib[1]; Icon = [System.Drawing.Icon]::ExtractAssociatedIcon((Resolve-Path ("evt.ico")).path)}
$PaquesToolTip     = New-Object System.Windows.Forms.ToolTip

$AnPaqueslabel     = New-Object System.Windows.Forms.Label -Property @{Location = "10, 14" ; Size = "70, 18" ; Text = "Anne : " ; TextAlign="MiddleLeft"}
$PaquesForm.Controls.Add($AnPaqueslabel)
$AnPaques     = New-Object System.Windows.Forms.TextBox -Property @{Location = "80, 13" ; Size = "40, 18" }
$PaquesForm.Controls.Add($AnPaques)
$PaquesCalcul      = New-Object System.Windows.Forms.Button -Property @{Location = "130, 12" ; Text = $table_lib[4]}
$PaquesCalcul.add_Click({calculpaques}) ; $PaquesForm.Controls.Add($PaquesCalcul)
$PaquesCalculSuiv      = New-Object System.Windows.Forms.Button -Property @{Location = "210, 12" ; width = 105 ; Text = $table_lib[10]}
$PaquesCalculSuiv.add_Click({$AnPaques.text = $AnPaques.text - 1 ; calculpaques}) ; $PaquesForm.Controls.Add($PaquesCalculSuiv)
$PaquesCalculPrec      = New-Object System.Windows.Forms.Button -Property @{Location = "320, 12" ; width = 95 ; Text = $table_lib[11]}
$PaquesCalculPrec.add_Click({$AnPaques.text = 1 + $AnPaques.text ; calculpaques}) ; $PaquesForm.Controls.Add($PaquesCalculPrec)
$AnPaques.text = (get-date -format "yyyy")


$PaquesDateGlabel     = New-Object System.Windows.Forms.Label -Property @{Location = "10, 44" ; Size = "110, 18" ; Text = $table_lib[2] ; TextAlign="MiddleLeft"}
$PaquesForm.Controls.Add($PaquesDateGlabel)
$PaquesJourG     = New-Object System.Windows.Forms.TextBox -Property @{Location = "130, 43" ; width = "40" ; enabled = $false}
$PaquesJourG.font  = new-object drawing.font($PaquesJourG.font,[Drawing.FontStyle]::Bold)
$PaquesForm.Controls.Add($PaquesJourG)
$PaquesJourG.text = ""
$PaquesMoisG     = New-Object System.Windows.Forms.TextBox -Property @{Location = "180, 43" ; width = "100" ; enabled = $false}
$PaquesMoisG.font  = new-object drawing.font($PaquesMoisG.font,[Drawing.FontStyle]::Bold)
$PaquesDateGlabel     = New-Object System.Windows.Forms.Label -Property @{Location = "290, 44" ; Size = "50, 18" ; Text = $table_lib[12] ; TextAlign="MiddleLeft"}
$PaquesForm.Controls.Add($PaquesDateGlabel)
$PaquesForm.Controls.Add($PaquesMoisG)
$PaquesMoisG.text = ""

$PaquesSourceG      = New-Object System.Windows.Forms.Button -Property @{Location = "340, 43" ; Text = $table_lib[6]}
$PaquesSourceG.add_Click({Start-Process "https://fr.wikipedia.org/wiki/Calcul_de_la_date_de_Pques"}) ; $PaquesForm.Controls.Add($PaquesSourceG)
$PaquesToolTip.SetToolTip($PaquesSourceG, "https://fr.wikipedia.org/wiki/Calcul_de_la_date_de_Pques")


$PaquesDateJlabel     = New-Object System.Windows.Forms.Label -Property @{Location = "10, 74" ; Size = "110, 18" ; Text = $table_lib[3] ; TextAlign="MiddleLeft"}
$PaquesForm.Controls.Add($PaquesDateJlabel)
$PaquesJourJ     = New-Object System.Windows.Forms.TextBox -Property @{Location = "130, 73" ; width = "40" ; enabled = $false}
$PaquesJourJ.font  = new-object drawing.font($PaquesJourJ.font,[Drawing.FontStyle]::Bold)
$PaquesForm.Controls.Add($PaquesJourJ)
$PaquesJourJ.text = ""
$PaquesMoisJ     = New-Object System.Windows.Forms.TextBox -Property @{Location = "180, 73" ; width = "100" ; enabled = $false}
$PaquesMoisJ.font  = new-object drawing.font($PaquesMoisJ.font,[Drawing.FontStyle]::Bold)
$PaquesForm.Controls.Add($PaquesMoisJ)
$PaquesMoisJ.text = ""
$PaquesJAide       = New-Object System.Windows.Forms.Button -Property @{Location = "290, 73" ; width = "20" ; text = "?"}
$PaquesJAide.add_Click({[System.Windows.Forms.Messagebox]::Show($table_lib[21],$table_lib[1],"OK","None")})
$PaquesForm.Controls.Add($PaquesJAide)

$PaquesSourceJ      = New-Object System.Windows.Forms.Button -Property @{Location = "340, 73" ; Text = $table_lib[6]}
$PaquesSourceJ.add_Click({Start-Process "https://fr.wikipedia.org/wiki/Calcul_de_la_date_de_Pques_selon_la_mthode_de_Gauss"}) ; $PaquesForm.Controls.Add($PaquesSourceJ)
$PaquesToolTip.SetToolTip($PaquesSourceJ, "https://fr.wikipedia.org/wiki/Calcul_de_la_date_de_Pques_selon_la_mthode_de_Gauss")


$PaquesDateJGlabel     = New-Object System.Windows.Forms.Label -Property @{Location = "10, 94" ; Size = "110, 38" ; Text = $table_lib[5] ; TextAlign="MiddleLeft"}
$PaquesForm.Controls.Add($PaquesDateJGlabel)
$PaquesJourJG     = New-Object System.Windows.Forms.TextBox -Property @{Location = "130, 103" ; width = "40" ; enabled = $false}
$PaquesJourJG.font  = new-object drawing.font($PaquesJourJG.font,[Drawing.FontStyle]::Bold)
$PaquesForm.Controls.Add($PaquesJourJG)
$PaquesJourJG.text = ""
$PaquesMoisJG     = New-Object System.Windows.Forms.TextBox -Property @{Location = "180, 103" ; width = "100" ; enabled = $false}
$PaquesMoisJG.font  = new-object drawing.font($PaquesMoisJG.font,[Drawing.FontStyle]::Bold)
$PaquesForm.Controls.Add($PaquesMoisJG)
$PaquesMoisJG.text = ""
$PaquesJGAide       = New-Object System.Windows.Forms.Button -Property @{Location = "290, 103" ; width = "20" ; text = "?"}
$PaquesJGAide.add_Click({[System.Windows.Forms.Messagebox]::Show($table_lib[22],$table_lib[1],"OK","None")})
$PaquesForm.Controls.Add($PaquesJGAide)

############################# objet calendrier
$Pcalendar = New-Object Windows.Forms.MonthCalendar -Property @{Location = "128, 135" ; ShowTodayCircle   = $false ; MaxSelectionCount = 1 ; ShowToday = $false ; enabled = $false ; visible = $false}
$PaquesForm.Controls.Add($Pcalendar)
$PaquesAide     = New-Object System.Windows.Forms.Label -Property @{Location = "128, 145" ; Size = "180, 100" ; TextAlign="MiddleLeft"
 Text = $table_lib[7]}
$PaquesForm.Controls.Add($PaquesAide)

############################# modif anne
$AnPaques.add_textchanged({$Pcalendar.visible = $false ; $PaquesJourJ.text = "" ; $PaquesMoisJ.text = "" ; $PaquesJourG.text = "" ; $PaquesMoisG.text = "" ; $PaquesJourJG.text = "" ; $PaquesMoisJG.text = ""})

############################# boutons Source, Affich, OK 
$PaquesSource     = New-Object System.Windows.Forms.Button -Property @{Location = "10, 305" ; width = "70" ; Text = $table_lib[6] + " 1"}
$PaquesSource.add_Click({Start-Process "https://promenade.imcce.fr/fr/pages4/440.html"})
$PaquesForm.Controls.Add($PaquesSource)
$PaquesToolTip.SetToolTip($PaquesSource, "https://promenade.imcce.fr/fr/pages4/440.html")

$PaquesSource2     = New-Object System.Windows.Forms.Button -Property @{Location = "90, 305" ; width = "70" ; Text = $table_lib[6] + " 2"}
$PaquesSource2.add_Click({Start-Process "https://www.imcce.fr/newsletter/docs/lesdatesdepaques.pdf"})
$PaquesForm.Controls.Add($PaquesSource2)
$PaquesToolTip.SetToolTip($PaquesSource2, "https://www.imcce.fr/newsletter/docs/lesdatesdepaques.pdf")

$PaquesAffich      = New-Object System.Windows.Forms.Button -Property @{Location = "180, 305" ; width = "120" ; Text = $table_lib[8]}
$PaquesAffich.add_Click({
if ($PaquesAffich.text -eq $table_lib[8]) {
$PaquesForm.height = 210 ; $PaquesAffich.text = $table_lib[9]
$PaquesAffich.Location = "180, 135" ; $PaquesSource.Location = "10, 135" ; $PaquesSource2.Location = "90, 135" ; $PaquesOK.Location = "340, 135" ; $PaquesAide.visible = $false
$Pcalendar.Location = "108, 215"} else {
$PaquesForm.height = 380 ; $PaquesAffich.text = $table_lib[8]
$PaquesAffich.Location = "180, 305" ; $PaquesSource.Location = "10, 305" ; $PaquesSource2.Location = "90, 305" ; $PaquesOK.Location = "340, 305" ; $PaquesAide.visible = $true
$Pcalendar.Location = "108, 135"}
})
$PaquesForm.Controls.Add($PaquesAffich)

$PaquesOK      = New-Object System.Windows.Forms.Button -Property @{Location = "340, 305" ; Text = "OK"}
$PaquesOK.add_Click({$PaquesForm.visible = $false}) ; $PaquesForm.Controls.Add($PaquesOK)
$PaquesForm.CancelButton  = $PaquesOK



####################################################################################################
# date de Paques : fonctions
function paques {
$PaquesForm.visible = $true
$x = $ecran.width - 500 ; $y = 400
$PaquesForm.location = new-object System.Drawing.Point $x,$y
} 

function calculpaques {
$Pcalendar.visible = $false

if ($AnPaques.text  -match "^[\d\.]+$") {
$cmd = New-Object -TypeName System.Data.SQLite.SQLiteCommand
$cmd.Connection = $global:conn_mem

# Paques julien
if (0 + $AnPaques.text -ge 325) {
$cmd.CommandText = ("select an, case when H > 31 then Q else H end jour, case when H > 31 then 4 else 3 end mois
from (select an, d, ee-7*(ee/7) e, 22 + d + ee-7*(ee/7) H, d + ee-7*(ee/7) - 9 Q
from (select an, 19*meton+15 - 30*((19*meton+15)/30) d , (2*b) + (4*c) + 6*(19*meton+15 - 30*((19*meton+15)/30)) + 6 ee
from (select an, an - 19*(an/19) meton, an - 4*(an/4) b, an - 7*(an/7) c
from (select " + $AnPaques.text + " an)
)))")
$lecture=$cmd.ExecuteReader()
while ($lecture.Read()) {$jourJ = $lecture.getValue(1) ; $moisJ = $lecture.getValue(2)}
# [System.Windows.Forms.Messagebox]::Show($jourJ,$moisJ) 
$lecture.Close()

if (0 + $AnPaques.text -gt 7999) {$res = [System.Windows.Forms.Messagebox]::Show($table_lib[23],$table_lib[1],1,"16") ; return}

$PaquesJourJ.text = $jourJ
if ($moisJ -eq "3") {$PaquesMoisJ.text = $table_mois[3]} else {$PaquesMoisJ.text = $table_mois[4]}

# conversion en grgorien
if (0 + $AnPaques.text -gt 1582) {
$cmd.CommandText = ("select strftime('%Y/%m/%d',julien) dateg
from (select jour + case mois when 1 then 0 when 2 then 31 when 3 then 59 when 4 then 90 when 5 then 120 when 6 then 151 when 7 then 181 when 8 then 212 when 9 then 243 when 10 then 273 when 11 then 304 when 12 then 334 end 
+ (an - 1)* 365 + ((an-1)/4) + case when an-4*(an/4) = 0 and mois > 2 then 1 else 0 end + 1721423 julien 
from (select " + $JourJ + " jour, " + $MoisJ + " mois, " + $AnPaques.text + " an)
)
")
$cmd.Connection = $global:conn_mem
$lecture=$cmd.ExecuteReader()
while ($lecture.Read()) { $dateG = $lecture.getValue(0) }
$lecture.Close()
$PaquesJourJG.text = $dateg.substring(8,2).trimstart("0")
if ($dateg.substring(5,2) -eq "03") {$PaquesMoisJG.text = $table_mois[3]} elseif
($dateg.substring(5,2) -eq "04") {$PaquesMoisJG.text = $table_mois[4]} elseif
($dateg.substring(5,2) -eq "05") {$PaquesMoisJG.text = $table_mois[5]} 
}

}

# Paques grgorien
if (0 + $AnPaques.text -gt 1582) {
$cmd.CommandText = ("select an,meton,epacte, lettre_dominicale, jm-31*(jm/31) + 1 jour, jm/31 mois
from (select an,meton,epacte, lettre_dominicale, epacte + lettre_dominicale - 7*((meton + (11*epacte) + (22*lettre_dominicale))/451) + 114 jm
from (select an,meton, epacte, ld-7*(ld/7) lettre_dominicale
from (select an,meton, epacte, 32 + 2*((an/100)-4*((an/100)/4)) + 2*(an_m100/4) - epacte - (an_m100-4*(an_m100/4)) ld 
from (select an,meton, ep - 30*(ep/30) epacte, an-100*(an/100) an_m100
from (select an,meton, 19*meton + (an/100) - ((an/100)/4) - ( (an/100) -((an/100) + 8)/25 + 1)/3  + 15 ep
from (select an, an - 19*(an/19) meton
from (select " + $AnPaques.text + " an)
))))))")
$lecture=$cmd.ExecuteReader()
while ($lecture.Read()) {$jourG = $lecture.getValue(4) ; $moisG = $lecture.getValue(5)}
# [System.Windows.Forms.Messagebox]::Show($jourJ,$moisJ) 
$lecture.Close()
$PaquesJourG.text = $jourG
if ($moisG -eq "3") {$PaquesMoisG.text = $table_mois[3]} else {$PaquesMoisG.text = $table_mois[4]}
if (0 + $AnPaques.text -ge 1753  -and 0 + $AnPaques.text -lt 9999) {$Pcalendar.visible = $true ; $dateG = new-object System.DateTime($AnPaques.text, $MoisG, $JourG) ; $Pcalendar.SelectionStart = $dateG}
}

$cmd.Dispose()

}
} 

####################################################################################################
#
# Affichage
#
####################################################################################################

$consolePtr = [Console.Window]::GetConsoleWindow()
[Console.Window]::ShowWindow($consolePtr, 0)

$PaquesForm.showdialog()

$PaquesForm.close
if ($global:conn_mem.state -eq "Open") {$global:conn_mem.close()}
if ($global:conn_mem.state -eq "Closed") {$global:conn_mem.dispose()}



